/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.debug.DebugState;
import org.squiddev.cobalt.function.Dispatch;
import org.squiddev.cobalt.unwind.SuspendedFunction;

public class ProtectedCall {
    private static final LuaValue ERROR_IN_HANDLER = ValueFactory.valueOf("error in error handling");
    private final LuaValue errorFunction;
    private final DebugFrame currentFrame;
    private SuspendedFunction<Varargs> currentTask;
    private LuaValue previousErrorFunction;
    private boolean isError;

    public ProtectedCall(DebugFrame currentFrame, @Nullable LuaValue errorFunction) {
        this.errorFunction = errorFunction;
        this.currentFrame = currentFrame;
    }

    public Result apply(LuaState state, LuaValue func, Varargs args) throws UnwindThrowable {
        return this.apply(state, new CallSuspended(func, args));
    }

    public Result apply(LuaState state, SuspendedFunction<Varargs> task) throws UnwindThrowable {
        if ((this.currentFrame.flags & 8) != 0) {
            throw new IllegalStateException("Cannot have nested pcalls");
        }
        if (this.currentTask != null) {
            throw new IllegalStateException("Already have a task present");
        }
        this.isError = false;
        this.currentTask = task;
        this.currentFrame.flags |= 8;
        this.previousErrorFunction = state.getCurrentThread().getErrorFunc();
        state.getCurrentThread().setErrorFunc(this.errorFunction);
        try {
            return this.finishSuccess(state, task.call(state));
        }
        catch (Exception | VirtualMachineError e) {
            return this.callErrorHandler(state, e);
        }
    }

    public Result resume(LuaState state, Varargs args) throws UnwindThrowable {
        if (this.currentTask != null) {
            try {
                return this.finishSuccess(state, (Varargs)this.currentTask.resume(args));
            }
            catch (Exception | VirtualMachineError e) {
                return this.callErrorHandler(state, e);
            }
        }
        return this.isError ? this.finishError(state, args.first()) : this.finishSuccess(state, args);
    }

    private void finish(LuaState state) {
        assert (DebugState.get(state).getStackUnsafe() == this.currentFrame);
        assert ((this.currentFrame.flags & 8) != 0);
        this.currentFrame.flags &= 0xFFFFFFF7;
        state.getCurrentThread().setErrorFunc(this.previousErrorFunction);
    }

    private Result finishSuccess(LuaState state, Varargs result) {
        this.currentTask = null;
        this.finish(state);
        return new Result(true, result);
    }

    public Result resumeError(LuaState state, LuaError error) throws UnwindThrowable {
        return this.isError ? this.finishError(state, ERROR_IN_HANDLER) : this.callErrorHandler(state, error);
    }

    private Result callErrorHandler(LuaState state, Throwable error) throws UnwindThrowable {
        LuaValue value;
        DebugState debug = DebugState.get(state);
        debug.getStackUnsafe().flags |= 0x10;
        if (this.currentTask != null) {
            this.currentTask = null;
        }
        this.isError = true;
        LuaError luaError = LuaError.wrap(error);
        luaError.fillTraceback(state);
        if (this.errorFunction == null) {
            value = luaError.getValue();
        } else {
            try {
                debug.growStackIfError();
                value = Dispatch.call(state, this.errorFunction, luaError.getValue());
            }
            catch (Exception | VirtualMachineError t) {
                value = ERROR_IN_HANDLER;
            }
        }
        return this.finishError(state, value);
    }

    private Result finishError(LuaState state, LuaValue result) {
        ProtectedCall.closeUntil(state, this.currentFrame);
        DebugState.get(state).shrinkStackIfError();
        this.finish(state);
        return new Result(false, result);
    }

    private static void closeUntil(LuaState state, DebugFrame top) {
        DebugFrame current;
        DebugState ds = DebugState.get(state);
        while ((current = ds.getStackUnsafe()) != top) {
            current.cleanup();
            ds.onReturnNoHook();
        }
    }

    private static class CallSuspended
    implements SuspendedFunction<Varargs> {
        private final LuaValue func;
        private final Varargs args;

        CallSuspended(LuaValue func, Varargs args) {
            this.func = func;
            this.args = args;
        }

        @Override
        public Varargs call(LuaState state) throws LuaError, UnwindThrowable {
            return Dispatch.invoke(state, this.func, this.args);
        }

        @Override
        public Varargs resume(Varargs args) {
            return args;
        }
    }

    public static final class Result {
        private final boolean isSuccess;
        private final Varargs result;

        Result(boolean isSuccess, Varargs result) {
            this.isSuccess = isSuccess;
            this.result = result;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public Varargs result() {
            return this.result;
        }

        public Varargs asBoolAndResult() {
            return ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf(this.isSuccess), this.result);
        }

        public Varargs asResultOrFailure() {
            return this.isSuccess ? this.result : ValueFactory.varargsOf(Constants.NIL, this.result);
        }
    }
}

